﻿using System;

namespace VA.PPMS.IWS.Common.Extensions
{
    public static class DateTimeExtensions
    {
        public static DateTime? ToCrmDate(this DateTime dt)
        {
            return new DateTime(dt.Year, dt.Month, dt.Day, dt.Hour, dt.Minute, dt.Second, DateTimeKind.Local);
        }

        public static DateTime StartOfWeek(this DateTime dt, DayOfWeek startOfWeek)
        {
            var delta = startOfWeek - dt.DayOfWeek;
            if (delta > 0) delta -= 7;

            return dt.AddDays(delta);
        }

        public static bool IsAfterHours(this DateTime dt)
        {
            return (dt.Hour / 4) < 1;
        }

        public static bool IsAfterHoursWeekend(this DateTime dt)
        {
            return (dt.DayOfWeek == DayOfWeek.Sunday && dt.IsAfterHours());
        }
    }
}
